/**  @file bta_bilateral.h
*
*    @brief This filter implements the bilateral filter
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>
#include <bta_filters.h>

#ifndef BTA_EXCLUDE_FILTERS

#ifndef BTA_BILATERAL_H_INCLUDED
#define BTA_BILATERAL_H_INCLUDED


typedef struct BTA_FltBilateralInst {
    BTA_ChannelId channelToProcess;
    BTA_ChannelId channelIdResult;
    BTA_InfoEventInst *infoEventInst;
} BTA_FltBilateralInst;


BTA_Status BFLTbilateralInit(BTA_FltBilateralConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTbilateralClose(BTA_FltHandle *handle);
BTA_Status BFLTbilateralApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
#endif